// $Id: CBaseImage.cpp,v 1.2 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CBaseImage.hpp"
#include <Exceptions/CException.hpp>
using Exponent::Exceptions::CException;
using Exponent::GUI::Graphics::CBaseImage;

//	===========================================================================
CBaseImage::CBaseImage()
	      : m_referenceCount(0)
	      , m_imageLoaded(false)
	      , m_theBitmap(NULL)
	      , m_hasAlpha(false)
{

}

//	===========================================================================
CBaseImage::~CBaseImage()
{
	this->unloadImage();
}

//	===========================================================================
void CBaseImage::unloadImage()
{
	m_imageLoaded   = false;
	m_filename		= " ";
	m_dimension.setDimension(0, 0);
	m_size.setRect(0, 0, 0, 0);
	if (m_theBitmap)
	{
	#ifdef WIN32
		DeleteObject(m_theBitmap);	
	#else
		CGImageRelease(m_theBitmap);
	#endif
		NULL_POINTER(m_theBitmap);
	}
}

//	===========================================================================
void CBaseImage::referenced()  
{ 
	m_referenceCount++; 
}

//	===========================================================================
void CBaseImage::dereference()
{
	m_referenceCount--;
	if (m_referenceCount <= 0)
	{
		delete this;
	}
}

//	===========================================================================
long CBaseImage::getReferenceCount() const 
{ 
	return m_referenceCount; 
}

//	===========================================================================
void CBaseImage::getObjectDescription(char *string, const long size) const
{
	if (this->m_imageLoaded)
	{
		CString str;
		str.setStringWithFormat("File loaded is = %s", m_filename.getString());
		strncpy(string, str.getString(), size * sizeof(char));
	}
	else
	{
		strncpy(string, "No Image loaded", size);
	}
}
